/*
 * Decompiled with CFR 0.152.
 */
package application;

import controller.MainController;
import controller.MatchController;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import kolibri.DatabaseLoader;
import kolibri.Library;
import kolibri.MainDatabase;
import kolibri.SceneController;

public class MainApplication
extends Application {
    public static void main(String[] args) {
        MainApplication.launch(args);
    }

    @Override
    public void start(Stage primaryStage) throws IOException {
        MainDatabase db;
        try {
            db = DatabaseLoader.load(Path.of("kolibri.json", new String[0]), MainDatabase.class);
        }
        catch (IOException e) {
            db = new MainDatabase();
        }
        Scene rootScene = new Scene(new Pane(), 900.0, 600.0);
        SceneController sceneController = new SceneController(rootScene);
        FXMLLoader mainLoader = new FXMLLoader(this.getClass().getResource("/fxml/MainView.fxml"));
        Parent mainRoot = (Parent)mainLoader.load();
        MainController mainController = (MainController)mainLoader.getController();
        sceneController.add("mainView", new SceneController.SceneWrapper("mainView", mainRoot, mainLoader));
        mainController.addSortOptions();
        Library library = db.getLibrary(0);
        sceneController.activate("mainView");
        FXMLLoader matchLoader = new FXMLLoader(this.getClass().getResource("/fxml/MatchView.fxml"));
        Parent matchRoot = (Parent)matchLoader.load();
        MatchController matchController = (MatchController)matchLoader.getController();
        sceneController.add("matchView", new SceneController.SceneWrapper("matchView", matchRoot, matchLoader));
        mainController.getMatchButton().addEventHandler(ActionEvent.ACTION, event -> sceneController.activate("matchView"));
        matchController.getSaveButton().addEventHandler(ActionEvent.ACTION, event -> sceneController.activate("mainView"));
        MainDatabase finalDb = db;
        mainController.getAddBookMenuItem().addEventHandler(ActionEvent.ACTION, event -> {
            SceneController.SceneWrapper bookScene = mainController.addNewBook();
            MatchController controller = (MatchController)bookScene.getLoader().getController();
            controller.getSaveButton().addEventHandler(ActionEvent.ACTION, e -> {
                try {
                    controller.setId(DatabaseLoader.getNextBookId(finalDb.getBooksPath()));
                }
                catch (IOException exception) {
                    controller.openAlert((ActionEvent)e, "Alert! error in: " + finalDb.getBooksPath().toString(), exception.getMessage());
                    return;
                }
                controller.updateBook();
                mainController.addGalleryItem(controller.getBook());
                sceneController.activate("mainView");
                sceneController.remove("matchView-newBook");
            });
            sceneController.add("matchView-newBook", bookScene);
            sceneController.activate("matchView-newBook");
        });
        mainController.getEditBookMenuItem().addEventHandler(ActionEvent.ACTION, event -> mainController.openAlert((ActionEvent)event, "Edit", "Not yet implemented!\nOpens the same view as \"Add New Book\", but with info from selected book"));
        mainController.getMatchBookMenuItem().addEventHandler(ActionEvent.ACTION, event -> mainController.openAlert((ActionEvent)event, "Edit", "Not yet implemented!\nOpens a dialog for Title and Authors before the same view as \"Edit Book\", and starts searching for online matches straight away"));
        mainController.getQuitMenuItem().addEventHandler(ActionEvent.ACTION, event -> primaryStage.close());
        Image icon = new Image(this.getStream("/images/icon-transparent.png"));
        primaryStage.getIcons().add(icon);
        primaryStage.setTitle("kolibri");
        primaryStage.setScene(rootScene);
        primaryStage.show();
    }

    public InputStream getStream(String resource) {
        return this.getClass().getResourceAsStream(resource);
    }
}

