/*
 * Decompiled with CFR 0.152.
 */
package kolibri;

import java.util.ArrayList;
import java.util.List;

public class Rating {
    private float rating;
    private int count;
    private int size;
    private String foreground;
    private String background;

    public float getRating() {
        return this.rating;
    }

    public void setRating(float rating) {
        this.rating = rating;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setForeground(String foreground) {
        this.foreground = foreground;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public Rating() {
        this(0.0f);
    }

    public Rating(float rating) {
        this.rating = rating;
        this.count = 5;
        this.size = 25;
        this.foreground = "#FF9900";
        this.background = "#333333";
    }

    public Rating(float rating, int count, int size, String foreground, String background) {
        this.rating = rating;
        this.count = count;
        this.size = size;
        this.foreground = foreground;
        this.background = background;
    }

    public String get() {
        float percent = this.rating / (float)this.count * 100.0f;
        return String.format("<!DOCTYPE html>\n<html>\n    <head>\n        <meta charset=\"UTF-8\">\n        <title>%.2f</title>\n        <style>\n            @charset \"UTF-8\";\n            .stars {\n              display: inline-block;\n              font-size: %dpx;\n              font-family: Times;\n              line-height: 1;\n            }\n            .stars::before {\n              content: \"%s\";\n              letter-spacing: 1px;\n              background: linear-gradient(270deg, %s %.2f%%, %s %.2f%%);\n              -webkit-background-clip: text;\n              -webkit-text-fill-color: transparent;\n            }\n            body {\n              background: transparent;\n              display: flex;\n              justify-content: right;\n              align-items: center;\n              height: 100vh;\n              margin: 0px;\n              overflow: hidden;\n            }\n            * {\n              position: relative;\n              box-sizing: border-box;\n            }\n        </style>\n    </head>\n    <body>\n        <div class=\"stars\">\n    </body>\n</html>", Float.valueOf(this.rating), this.size, "*".repeat(this.count), this.background, Float.valueOf(1.0f - percent), this.foreground, Float.valueOf(1.0f - percent));
    }

    public String toString() {
        return this.get();
    }

    public static List<String> getStarList(int end) {
        return Rating.getStarList(0, end);
    }

    public static List<String> getStarList(int start, int end) {
        start = Integer.max(0, start);
        end = Integer.max(1, end);
        int amount = end - start + 1;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = start; i <= end; ++i) {
            list.add("\u2605".repeat(i));
        }
        return list;
    }
}

