/*
 * Decompiled with CFR 0.152.
 */
package controller;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import javafx.fxml.FXML;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.web.WebView;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import kolibri.Book;
import kolibri.Rating;

public class GalleryItemController {
    private Book book;
    private int id;
    private Path coverPath;
    @FXML
    private Label author;
    @FXML
    private ImageView cover;
    @FXML
    private Rectangle progress;
    @FXML
    private WebView rating;
    @FXML
    private Label series;
    @FXML
    private Label seriesNumber;
    @FXML
    private TextArea synopsis;
    @FXML
    private Label title;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getAuthor() {
        return this.author.getText();
    }

    public List<String> getAuthors() {
        return Arrays.stream(this.author.getText().split(", ")).toList();
    }

    public void setAuthor(Label author) {
        this.author = author;
    }

    public void setAuthor(String author) {
        this.author.setText(author);
    }

    public ImageView getCover() {
        return this.cover;
    }

    public Path getCoverPath() {
        return this.coverPath;
    }

    public void setCoverPath(Path path) {
        this.coverPath = path;
    }

    public void setCover(ImageView cover) {
        this.cover = cover;
    }

    public void setCover(InputStream is) {
        Image image = new Image(is, -1.0, -1.0, true, true);
        this.cover.setImage(image);
    }

    public void setCover(Path path) throws FileNotFoundException {
        if (path == null) {
            InputStream is = this.getClass().getResourceAsStream("/images/blank.png");
            this.setCover(is);
            this.setCoverPath(null);
            return;
        }
        try {
            FileInputStream is = new FileInputStream(path.toFile());
            this.setCover(is);
            this.setCoverPath(path);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(path.toAbsolutePath().toString());
        }
    }

    public void setCover(String path) throws FileNotFoundException {
        this.setCover(Path.of(path, new String[0]));
    }

    public Book.Progress getProgress() {
        return Book.Progress.type((Color)this.progress.getFill());
    }

    public void setProgress(Rectangle progress) {
        this.progress = progress;
    }

    public void setProgress(Book.Progress progress) {
        this.progress.setFill(progress.color);
    }

    public float getRating() {
        return Float.parseFloat(this.rating.getEngine().getDocument().getElementsByTagName("title").item(0).getTextContent());
    }

    public void setRating(WebView rating) {
        this.rating = rating;
    }

    public void setRating(Rating rating) {
        this.rating.getEngine().loadContent(rating.get());
    }

    public void setRating(float rating) {
        Rating r = new Rating(rating);
        this.rating.getEngine().loadContent(r.get());
    }

    public String getSeries() {
        return this.series.getText();
    }

    public void setSeries(Label series) {
        this.series = series;
    }

    public void setSeries(String series) {
        this.series.setText(series);
    }

    public float getSeriesNumber() {
        String number = this.seriesNumber.getText();
        return number != null ? Float.parseFloat(number.substring(1)) : -1.0f;
    }

    public void setSeriesNumber(float number) {
        if (number < 0.0f) {
            this.seriesNumber.setText("");
            return;
        }
        DecimalFormat format = new DecimalFormat("#.#");
        String num = format.format(number);
        this.seriesNumber.setText(String.format("#%s", num));
    }

    public String getSynopsis() {
        return this.synopsis.getText();
    }

    public void setSynopsis(TextArea synopsis) {
        this.synopsis = synopsis;
    }

    public void setSynopsis(String synopsis) {
        this.synopsis.setText(synopsis);
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void setTitle(Label title) {
        this.title = title;
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    @FXML
    public void popupCover(MouseEvent event) {
        Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
        Scene scene = ((Node)event.getTarget()).getScene();
        Stage window = (Stage)scene.getWindow();
        double screenWidth = bounds.getWidth();
        double screenHeight = bounds.getHeight();
        double sceneWidth = scene.getWidth();
        double sceneHeight = scene.getHeight();
        double windowWidth = window.getWidth();
        double windowHeight = window.getHeight();
        double maxWidth = screenWidth - windowWidth + sceneWidth;
        double maxHeight = screenHeight - windowHeight + sceneHeight;
        Image image = ((ImageView)event.getTarget()).getImage();
        ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
        imageView.setFitWidth(maxWidth);
        imageView.setFitHeight(maxHeight);
        Dialog dialog = new Dialog();
        DialogPane dialogPane = dialog.getDialogPane();
        Window dialogWindow = dialogPane.getScene().getWindow();
        dialogWindow.setOnCloseRequest(e -> dialogWindow.hide());
        dialog.setTitle("Cover");
        dialogPane.setContent(imageView);
        dialogPane.getChildren().remove(dialogPane.lookup(".button-bar"));
        dialog.showAndWait();
    }

    @FXML
    public void progressNext(MouseEvent event) {
        Rectangle rectangle = (Rectangle)event.getTarget();
        Color color = (Color)((Rectangle)event.getTarget()).getFill();
        Color next = Book.Progress.type((Color)color).next().color;
        rectangle.setFill(next);
    }

    public void loadBook(Book book) {
        this.book = book;
        try {
            Path path = book.getCovers().get("front");
            this.setCover(path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.setProgress(Book.Progress.UNREAD);
        this.setTitle(book.getTitle());
        this.setRating(book.getRating());
        this.setSeries(book.getSeries());
        this.setSeriesNumber(book.getSeriesNumber());
        this.setAuthor(book.getAuthorsAsString());
        this.setSynopsis(book.getSynopsis());
    }
}

