/*
 * Decompiled with CFR 0.152.
 */
package controller;

import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import kolibri.Book;
import kolibri.Rating;

public class MatchController {
    private Book book;
    private int id;
    private Path coverPath;
    @FXML
    private Font x3;
    @FXML
    private Color x4;
    @FXML
    private Button contextButton;
    @FXML
    private Button selectButton;
    @FXML
    private Button searchButton;
    @FXML
    private Button saveButton;
    @FXML
    private Button nextButton;
    @FXML
    private Button prevButton;
    @FXML
    private TextArea synopsis;
    @FXML
    private ImageView cover;
    @FXML
    private TextField IDs;
    @FXML
    private TextField authors;
    @FXML
    private TextField date;
    @FXML
    private TextField language;
    @FXML
    private TextField pubDate;
    @FXML
    private TextField publisher;
    @FXML
    private TextField series;
    @FXML
    private TextField seriesNumber;
    @FXML
    private TextField tags;
    @FXML
    private TextField title;
    @FXML
    private ChoiceBox<String> rating;
    @FXML
    private VBox commentsVBox;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private MenuItem saveMenuItem;
    @FXML
    private MenuItem discardMenuItem;
    @FXML
    private MenuItem aboutMenuItem;

    public Book getBook() {
        return this.book;
    }

    public void setBook(Book book) {
        this.book = book;
    }

    public Button getSaveButton() {
        return this.saveButton;
    }

    public Button getSearchButton() {
        return this.searchButton;
    }

    public Button getPrevButton() {
        return this.prevButton;
    }

    public Button getContextButton() {
        return this.contextButton;
    }

    public Button getSelectButton() {
        return this.selectButton;
    }

    public Button getNextButton() {
        return this.nextButton;
    }

    public void setAuthors(String[] authors) {
        this.authors.setText(String.join((CharSequence)", ", authors));
    }

    public void setDate(LocalDateTime date) {
        this.date.setText(date.format(DateTimeFormatter.ofPattern("dd/MM/yyyy   HH:mm:ss")));
    }

    public void setPubDate(LocalDateTime date) {
        this.pubDate.setText(date.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
    }

    public void setSynopsis(String synopsis) {
        this.synopsis.setText(synopsis);
    }

    public String getTitle() {
        return this.title.getText();
    }

    public TextField getTitleNode() {
        return this.title;
    }

    public ImageView getCover() {
        return this.cover;
    }

    public Path getCoverPath() {
        return this.coverPath;
    }

    public void setCoverPath(Path path) {
        this.coverPath = path;
    }

    public void setCover(ImageView cover) {
        this.cover = cover;
    }

    public float getRating() {
        String rating = this.rating.getValue();
        return rating != null ? (float)rating.length() : 0.0f;
    }

    public void setRating(ChoiceBox<String> rating) {
        this.rating = rating;
    }

    public void setRating(Rating rating) {
        this.setRating(rating.getRating());
    }

    public void setRating(float rating) {
        this.rating.getSelectionModel().select((int)(rating + 0.5f));
    }

    public void setRating(int start, int end) {
        List<String> list = Rating.getStarList(start, end);
        ObservableList<String> observableList = FXCollections.observableList(list);
        this.rating.setItems(observableList);
    }

    public String getSeries() {
        return this.series.getText();
    }

    public void setSeries(String series) {
        this.series.setText(series);
    }

    public void setSeries(TextField series) {
        this.series = series;
    }

    public float getSeriesNumber() {
        try {
            return Float.parseFloat(this.seriesNumber.getText());
        }
        catch (NumberFormatException e) {
            return -1.0f;
        }
    }

    public void setSeriesNumber(float number) {
        if (number < 0.0f) {
            this.seriesNumber.clear();
        }
        this.seriesNumber.setText(String.format("%.2f", Float.valueOf(number)));
    }

    public void setSeriesNumber(TextField number) {
        this.seriesNumber = number;
    }

    public List<String> getAuthors() {
        return Arrays.stream(this.authors.getText().split(", ")).toList();
    }

    public void setAuthors(List<String> authors) {
        this.setAuthors(authors.toArray(new String[0]));
    }

    public void setAuthors(String author) {
        this.setAuthors(new String[]{author});
    }

    public void setAuthors(TextField number) {
        this.authors = number;
    }

    public String getSynopsis() {
        return this.synopsis.getText();
    }

    public HashMap<String, String> getIDs() {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] kvp = this.IDs.getText().split(", ");
        if (kvp[0].isEmpty()) {
            return null;
        }
        for (String kv : kvp) {
            String[] kvs = kv.split(": ");
            map.put(kvs[0], kvs[1]);
        }
        return map;
    }

    public String getLanguage() {
        return this.language.getText();
    }

    public String getPublisher() {
        return this.publisher.getText();
    }

    public List<String> getTags() {
        return Arrays.stream(this.tags.getText().split(", ")).toList();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void prevCover(ActionEvent event) {
        this.openAlert(event, "Cover", "Not yet implemented!\nSelects previous cover from list");
    }

    public void contextCover(ActionEvent event) {
        this.openAlert(event, "Cover", "Not yet implemented!\nOpens a context menu for cover");
    }

    public void selectCover(ActionEvent event) {
        this.openAlert(event, "Cover", "Not yet implemented!\nSaves the cover to FileSystem and adds it to Book");
    }

    public void nextCover(ActionEvent event) {
        this.openAlert(event, "Cover", "Not yet implemented!\nSelects next cover from list");
    }

    public void searchOnline(ActionEvent event) {
        this.openAlert(event, "Search online", "Not yet implemented!\nSearch online with the Title and Authors");
    }

    public void saveEdits(ActionEvent event) {
        this.openAlert(event, "Save", "Not yet implemented!\nSame as Save button");
    }

    public void discardEdits(ActionEvent event) {
        this.openAlert(event, "Discard", "Not yet implemented!\nReturns to MainView without saving");
    }

    public void openAbout(ActionEvent event) {
        Dialog dialog = new Dialog();
        dialog.setTitle("About kolibri");
        dialog.setContentText("View at https://gitlab.jyu.fi/solismpa/kolibri");
        dialog.getDialogPane().getButtonTypes().add(ButtonType.CLOSE);
        Node closeButton = dialog.getDialogPane().lookupButton(ButtonType.CLOSE);
        closeButton.managedProperty().bind(closeButton.visibleProperty());
        closeButton.setVisible(false);
        dialog.showAndWait();
    }

    public void updateBook() {
        HashMap<String, Path> coverMap = new HashMap<String, Path>();
        coverMap.put("front", this.getCoverPath());
        this.book.setCovers(coverMap);
        this.book.setTitle(this.getTitle());
        this.book.setRating(this.getRating());
        this.book.setSeries(this.getSeries());
        this.book.setSeriesNumber(this.getSeriesNumber());
        this.book.setAuthors(this.getAuthors());
        this.book.setSynopsis(this.getSynopsis());
        this.book.setDateAdded();
        this.book.setDateModified();
        this.book.setIds(this.getIDs());
        this.book.setLanguage(this.getLanguage());
        this.book.setPublisher(this.getPublisher());
        this.book.setTags(this.getTags());
        this.book.setId(this.getId());
    }

    public void initialize() {
        this.setRating(0, 5);
    }

    public void openAlert(ActionEvent event, String title, String content) {
        Dialog dialog = new Dialog();
        dialog.setTitle(title);
        dialog.setContentText(content);
        dialog.getDialogPane().getButtonTypes().add(ButtonType.CLOSE);
        Node closeButton = dialog.getDialogPane().lookupButton(ButtonType.CLOSE);
        closeButton.managedProperty().bind(closeButton.visibleProperty());
        closeButton.setVisible(false);
        dialog.showAndWait();
    }
}

