/*
 * Decompiled with CFR 0.152.
 */
package kolibri;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.paint.Color;
import kolibri.Comment;
import kolibri.DatabaseLoader;

public class Book {
    private Path path;
    private int id = -1;
    private String title;
    private String series;
    private float seriesNumber;
    private List<String> authors;
    private String publisher;
    private Type type;
    private Instant date;
    private Instant dateAdded;
    private Instant dateModified;
    private String language;
    private int pages;
    private String edition;
    private HashMap<String, Path> covers = new HashMap();
    private String synopsis;
    private List<String> tags;
    private float rating;
    private float onlineRating;
    private Comment comment;
    private List<Comment> onlineComments;
    private String note;
    private Progress progress;
    private Instant progressDate;
    private HashMap<String, String> ids = new HashMap();

    @JsonIgnore
    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSeries() {
        return this.series;
    }

    public void setSeries(String series) {
        this.series = series;
    }

    public float getSeriesNumber() {
        return this.seriesNumber;
    }

    public void setSeriesNumber(float number) {
        this.seriesNumber = number;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    @JsonIgnore
    public String getAuthorsAsString() {
        if (this.authors == null) {
            return "";
        }
        return String.join((CharSequence)", ", this.authors);
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    @JsonIgnore
    public void setAuthors(String authors) {
        if (authors == null) {
            this.authors = new ArrayList<String>();
            return;
        }
        this.authors = new ArrayList<String>(Arrays.asList(authors.split(", ")));
    }

    public void addAuthor(String author) {
        this.authors.add(author);
    }

    public void removeAuthor(String author) {
        this.authors.remove(author);
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Instant getDate() {
        return this.date;
    }

    public void setDate() {
        this.date = Instant.now();
    }

    public void setDate(Instant date) {
        this.date = date;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public String getEdition() {
        return this.edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public Map<String, Path> getCovers() {
        if (this.covers == null || this.covers.isEmpty()) {
            this.addCover("front", null);
        }
        return this.covers;
    }

    public void setCovers(HashMap<String, Path> covers) {
        if (covers == null || covers.isEmpty()) {
            this.addCover("front", null);
            return;
        }
        this.covers = covers;
    }

    public void addCover(String type, Path path) {
        this.covers.put(type, path);
    }

    public String getSynopsis() {
        return this.synopsis;
    }

    public void setSynopsis(String synopsis) {
        this.synopsis = synopsis;
    }

    public List<String> getTags() {
        return this.tags;
    }

    @JsonIgnore
    public String getTagsAsString() {
        return String.join((CharSequence)", ", this.tags);
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonIgnore
    public void setTags(String tags) {
        if (tags == null) {
            this.tags = new ArrayList<String>();
            return;
        }
        this.tags = new ArrayList<String>(Arrays.asList(tags.split(", ")));
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float rating) {
        this.rating = rating;
    }

    public double getOnlineRating() {
        return this.onlineRating;
    }

    public void setOnlineRating(float rating) {
        this.onlineRating = rating;
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public List<Comment> getOnlineComments() {
        return this.onlineComments;
    }

    public void setOnlineComments(List<Comment> comments) {
        if (comments == null) {
            this.onlineComments = new ArrayList<Comment>();
            return;
        }
        this.onlineComments = comments;
    }

    public void addOnlineComments(Comment comment) {
        this.onlineComments.add(comment);
    }

    public void removeOnlineComments(Comment comment) {
        this.onlineComments.remove(comment);
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Progress getProgress() {
        return this.progress;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public Instant getProgressDate() {
        return this.progressDate;
    }

    public void setProgressDate() {
        this.progressDate = Instant.now();
    }

    public void setProgressDate(Instant date) {
        this.progressDate = date;
    }

    public Instant getDateAdded() {
        return this.dateAdded;
    }

    public void setDateAdded() {
        this.dateAdded = Instant.now();
    }

    public void setDateAdded(Instant date) {
        this.dateAdded = date;
    }

    public Instant getDateModified() {
        return this.dateModified;
    }

    public void setDateModified() {
        this.dateModified = Instant.now();
    }

    public void setDateModified(Instant date) {
        this.dateModified = date;
    }

    public Map<String, String> getIds() {
        return this.ids;
    }

    @JsonIgnore
    public String getIdsAsString() {
        return this.ids.keySet().stream().map(k -> k + ": " + this.ids.get(k)).collect(Collectors.joining(", "));
    }

    public void setIds(HashMap<String, String> ids) {
        this.ids = ids;
    }

    @JsonIgnore
    public void setIds(String ids) {
        if (ids == null) {
            this.ids = new HashMap();
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String kvp : ids.split(", ")) {
            String[] kv = kvp.split(": ");
            map.put(kv[0], kv[1]);
        }
        this.ids = map;
    }

    public void addIds(String name, String value) {
        this.ids.put(name, value);
    }

    public void removeIds(String name) {
        this.ids.remove(name);
    }

    public Book() {
        this.authors = new ArrayList<String>();
        this.tags = new ArrayList<String>();
        this.onlineComments = new ArrayList<Comment>();
        this.dateAdded = Instant.now();
        this.dateModified = Instant.now();
        this.setRating(0.0f);
        this.addCover("front", null);
    }

    public String toString() {
        try {
            return DatabaseLoader.toString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Type {
        ALMANAC,
        ANTHOLOGY,
        BIOGRAPHY,
        CATALOGUE,
        CHILDRENS,
        COLORING,
        COMIC,
        COOKBOOK,
        DIARY,
        DICTIONARY,
        ENCYCLOPEDIA,
        ESSAY,
        GENERAL,
        GRAPHIC,
        GUIDEBOOK,
        HANDBOOK,
        JOURNAL,
        MAGAZINE,
        MANUAL,
        MEMOIR,
        MONOGRAPH,
        NEWSPAPER,
        NOVEL,
        NOVELLA,
        PHOTO,
        POETRY,
        PROCEEDING,
        PROFESSIONAL,
        REFERENCE,
        RELIGIOUS,
        SHORTSTORY,
        TEXTBOOK,
        THESIS,
        TRAVELOGUE,
        WEBSERIAL,
        WEBTOON;

        private static final Type[] vals;

        public static Type type(String name) {
            for (Type t : vals) {
                if (!t.toString().equalsIgnoreCase(name)) continue;
                return t;
            }
            return NOVEL;
        }

        static {
            vals = Type.values();
        }
    }

    public static enum Progress {
        UNREAD(Color.web("0xffcc0080")),
        STARTED(Color.web("0x3d85c680")),
        DROPPED(Color.web("0xcc000080")),
        FINISHED(Color.web("0x6aa84f80")),
        WISHLIST(Color.web("0xeae4db80"));

        public final Color color;
        private static final Progress[] vals;

        private Progress(Color color) {
            this.color = color;
        }

        public static Progress type(Color color) {
            for (Progress e : vals) {
                if (!e.color.equals(color)) continue;
                return e;
            }
            return UNREAD;
        }

        public Progress next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        public String toString() {
            return this.color.toString();
        }

        static {
            vals = Progress.values();
        }
    }

    public static enum Sort {
        ID("ID"),
        TITLE("Title"),
        SERIES("Series"),
        AUTHOR("Author"),
        RATING("Rating"),
        TAG("Tags / genres"),
        DATE_ADDED("Date added"),
        DATE_PUBLISHED("Date published");

        public final String name;

        private Sort(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static String[] toArray() {
            return (String[])Arrays.stream(Sort.values()).map(Sort::toString).toArray(String[]::new);
        }
    }

    public static enum NameSort {
        FIRSTNAME,
        LASTNAME;

        private static final NameSort[] vals;

        public static NameSort type(String s) {
            for (NameSort e : vals) {
                if (!e.name().toLowerCase().equals(s)) continue;
                return e;
            }
            return LASTNAME;
        }

        static {
            vals = NameSort.values();
        }
    }
}

