/*
 * Decompiled with CFR 0.152.
 */
package kolibri;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.stream.Stream;
import kolibri.Book;

public class DatabaseLoader {
    public static ObjectMapper getMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules().setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ssXXX")).enable(SerializationFeature.INDENT_OUTPUT).enable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper;
    }

    public static <T> T load(Path path, Class<T> type) throws IOException {
        if (!path.toFile().isFile()) {
            throw new IOException(String.valueOf(path.toAbsolutePath()) + " is not a file.");
        }
        return DatabaseLoader.getMapper().readValue(path.toFile(), type);
    }

    public static <T> T load(String json, Class<T> type) throws JsonProcessingException {
        return DatabaseLoader.getMapper().readValue(json, type);
    }

    public static void save(Path path, Object object) throws IOException {
        File root = (path = path.toAbsolutePath()).getParent().toFile();
        if (!root.exists()) {
            root.mkdirs();
        }
        ObjectMapper mapper = DatabaseLoader.getMapper();
        mapper.writeValue(path.toFile(), object);
    }

    public static String toString(Object object) throws JsonProcessingException {
        return DatabaseLoader.getMapper().writeValueAsString(object);
    }

    public static int tryParse(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int getNextBookId(Path path) throws IOException {
        return Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(e -> DatabaseLoader.tryParse(e.getFileName().toString(), -1)).max(Integer::compare).orElse(0);
    }

    private static boolean checkIfEmpty(Path directory) {
        boolean bl;
        block8: {
            Stream<Path> stream = Files.list(directory);
            try {
                bl = stream.anyMatch(p -> !Files.isDirectory(p, new LinkOption[0]));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    public static void main(String[] args) {
        try {
            Book book = DatabaseLoader.load(Path.of("meta.json", new String[0]), Book.class);
            System.out.println(DatabaseLoader.toString(book));
            DatabaseLoader.save(Path.of("meta-cp.json", new String[0]), book);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

