/*
 * Decompiled with CFR 0.152.
 */
package kolibri;

import java.util.HashMap;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;

public class SceneController {
    private final HashMap<String, SceneWrapper> sceneMap = new HashMap();
    private final Scene main;
    private String active;

    public SceneController(Scene main) {
        this.main = main;
    }

    public Parent getNode(String name) {
        return this.sceneMap.get(name).getNode();
    }

    public String getActive() {
        return this.active;
    }

    public Parent getActiveNode() {
        return this.sceneMap.get(this.active).getNode();
    }

    public void add(String name, SceneWrapper scene) {
        this.sceneMap.put(name, scene);
    }

    public void remove() {
        this.sceneMap.remove(this.getActive());
    }

    public void remove(String name) {
        this.sceneMap.remove(name);
    }

    public void activate(String name) {
        this.main.setRoot(this.sceneMap.get(name).getNode());
        this.active = name;
    }

    public static class SceneWrapper {
        private final String name;
        private final Parent node;
        private final FXMLLoader loader;

        public SceneWrapper(String name, Parent node, FXMLLoader loader) {
            this.name = name;
            this.node = node;
            this.loader = loader;
        }

        public String getName() {
            return this.name;
        }

        public Parent getNode() {
            return this.node;
        }

        public FXMLLoader getLoader() {
            return this.loader;
        }
    }
}

