"use strict";
//@ts-check 
// TIEA2120 Viikkotehtävä 1 - 2025 syksy
// Taso 1
// Kirjoita tästä eteenpäin oma ohjelmakoodisi
// Tutki selaimen konsolista käsiteltävänä olevaa dataa.
// Data löytyy myös data2025s.json-tiedostosta. 
// Huom! Et saa millään tavalla muokata data2025s.json-tiedostoa!
/**
  * Palauttaa merkkijonoja sisältävän aakkosjärjestyksessä olevan taulukon kaikista rastikoodeista
  * @param {Object} data Objekti, jonka sisältämien rastien koodit järjestetään
  * @return {Array} palauttaa järjestetyn taulukon rastit-taulukon rastikoodeista
  */
let jarjestaRastikoodit = function(data) {
  console.log("jarjestaRastikoodit", data);
  let rastit = data?.kisa?.rastit;
  // Ottaa mahdolliset rastikoodit ja sorttaa ne.
  // Alkuperäisessä @return kommentissa sanottiin funktion palauttavan kopion rastit taulukosta,
  //   mutta tuo on väärin mallikuvan ja järjen mukaan.
  if (rastit.map) {
    return rastit.map(e => e.koodi)
      .filter(e => e)
      .toSorted((a, b) => a.localeCompare(b, 'fi', {sensitivity: 'base'}));
  }
  return [];  // palauttaa tyhjän taulukon jos data oli virheellistä
};


/**
  * Järjestää sarjat niiden keston perusteella eli lyhin sarja ensimmäisenä
  * Alkuperäistä rakennetta ei saa muuttaa tai korvata vaan järjestäminen tehdään alkup. taulukon kopiolle.
  * @param {Object} data Objekti, jonka sisältämät sarjaobjektit järjestetään 
  * @return {Array} palauttaa järjestetyn _kopion_ sarjat-taulukosta
  */
let jarjestaSarjat = function(data) {
  console.log("jarjestaSarjat", data);
  let sarjat = data?.kisa?.sarjat;
  // Tämä palauttaa _taulukon_ kopion, mutta taulukon elementit ovat viitteitä, mikä ainakin tässä tehtävässä on tarpeeksi
  if (sarjat.filter) {
    return sarjat.filter(e => e.kesto)
      .toSorted((a, b) => a.kesto - b.kesto);
  }
  return [];  // palauttaa tyhjän taulukon jos data oli virheellistä
};


/**
  * Palauttaa aakkosjärjestyksessä olevan taulukon kaikkien joukkueiden jäsenistä
  * @param {Object} data Objekti, jonka sisältämien joukkueiden jäsenet kerätään yhteen taulukkoon ja järjestetään
  * kasvavaan aakkosjärjestykseen. Isoilla ja pienillä kirjaimilla ei ole järjestämisessä merkitystä.
  * @return {Array} palauttaa järjestetyn taulukon
  */
let jarjestaJasenet = function(data) {
  console.log("jarjestaJasenet", data);
  let joukkueet = data?.kisa?.joukkueet;
  if (joukkueet.map) {
    return joukkueet.map(e => e.jasenet)
      .flat()
      .filter(e => e)
      .toSorted((a, b) => a.localeCompare(b, 'fi', {sensitivity: 'base'}));
  }
  return [];  // tässä palautetaan taulukko rastikoodeista
};




