"use strict";
//@ts-check 
// TIEA2120 Viikkotehtävä 1 - 2025 syksy
// Tämä tiedosto on tasoille 3 - 5. Toteuta ensin erillinen tason 1 -tehtävä!
// Selaimen konsolista voit tarkistaa automaattisesti suoritettavien testien mahdolliset virheilmoitukset
// Joukkueen sarja on viite data.sarjat-taulukossa lueteltuihin sarjoihin
// Joukkueen rastileimausten rastit ovat viitteitä data.rastit-Objektissa oleviin rasteihin
// Kirjoita tästä eteenpäin oma ohjelmakoodisi


/** Muuttaa merkkijonoksi, trimmaa ja vertaa `fi` lokaalin mukaan annetut arvot `a` ja `b`
 * @param {any} a Ensimmäinen verrattava arvo
 * @param {any} b Toinen verrattava arvo
 * @param {Object} [options] Valinnaiset optiot localeCompare functiolle. Default: {sensitivity: 'base'}
 * @returns {number} `-1, 0 tai 1` {@link String.prototype.localeCompare} tuloksen ja optioiden mukaan
*/ 
function trimLocaleCompare(a, b, options) {
  return a.toString().trim().localeCompare(b.toString().trim(), 'fi', Object.assign({sensitivity: 'base'}, options));
}

/** Wrapper object for getLahtoMaali return data
 * @typedef {Object} LahtoMaaliReturnObject
 * @property {Array} rastileimaukset
 * @property {Object} lahto - Last element with koodi: "LAHTO"
 * @property {Object} maali - First element with koodi: "MAALI" after the last "LAHTO"
 * @property {number} lahtoIndex - Index of the last element with koodi: "LAHTO"
 * @property {number} maaliIndex - Index of the first element with koodi: "MAALI" after the last "LAHTO"
 */

/** Creates shallow copy of the given rastileimaukset, filters invalid data and sorts by aika
 * @param {Array} rastileimaukset 
 * @returns {LahtoMaaliReturnObject}
 */
function getLahtoMaali(rastileimaukset) {
  const fsrl = rastileimaukset
    .filter(e =>
      new Date(e.aika).toString() !== "Invalid Date" &&
        typeof e.rasti === "object" &&
        typeof e.rasti.koodi === "string" &&
        !isNaN(parseFloat(e.rasti.lat)) &&
        !isNaN(parseFloat(e.rasti.lon))
    )
    .toSorted((a, b) => new Date(a.aika) - new Date(b.aika));
  const lahto = fsrl.findLast(e => e.rasti?.koodi == "LAHTO");
  const lahtoIndex = fsrl.indexOf(lahto);
  const maali = fsrl.slice(lahtoIndex).find(e => e.rasti?.koodi == "MAALI");
  const maaliIndex = fsrl.indexOf(maali);
  return {rastileimaukset: fsrl, lahto, maali, lahtoIndex, maaliIndex};
}

/**
 * Converts milliseconds to "hh:mm:ss" string, dropping extra milliseconds
 * @param {number} ms Milliseconds
 * @returns {string} Given duration in "hh:mm:ss" formatted string
 */
function ms2timeString(ms) {
  let seconds = ms / 1000 | 0;  // Floor
  const hh = (seconds / 3600 | 0).toString().padStart(2, "0");
  seconds %= 3600;
  const mm = (seconds / 60 | 0).toString().padStart(2, "0");
  const ss = (seconds % 60).toString().padStart(2, "0");
  return `${hh}:${mm}:${ss}`;
}

/** Palauttaa seuraavan kokonaisluvun taulukon objektien suurimmasta id:n arvosta, tai 1
 */
const getID = (arr) => Math.max(0, Math.max(...(arr ?? []).map(e => e.id).filter(Number.isSafeInteger))) + 1;


/**
  * Taso 3
  * Järjestää leimaustavat aakkosjärjestykseen 
  * isoilla ja pienillä kirjaimilla ei ole järjestämisessä merkitystä (case insensitive). "FOO" on sama kuin "foo".
  * Leimaustavan nimen alussa tai lopussa olevalle whitespacella ei myöskääm ole merkitystä. "  foo " on siis sama kuin "foo"
  * Alkuperäistä rakennetta ei saa muuttaa tai korvata vaan järjestäminen tehdään alkup. taulukon kopiolle.
  * Järjestetty lista leimaustavoista näkyy sivulla olevalla lomakkeella
  * @param {Array} leimaustavat-taulukko, jonka kopio järjestetään 
  * @return {Array} palauttaa järjestetyn _kopion_ leimaustavat-taulukosta
*/
function jarjestaLeimaustavat(leimaustavat) {
//  console.log("jarjestaLeimaustavat", leimaustavat);
   // tässä pitää palauttaa järjestetty kopio eikä alkuperäistä
  return leimaustavat?.toSorted(trimLocaleCompare) ?? [];
}

/**
  * Taso 3
  * Järjestää sarjat aakkosjärjestykseen sarjan keston perusteella eli lyhin sarja ensimmäisenä
  * Alkuperäistä rakennetta ei saa muuttaa tai korvata vaan järjestäminen tehdään alkup. taulukon kopiolle.
  * Järjestetetyt sarjat näkyvät sivulla olevalla lomakkeella
  * @param {Array} taulukko, jonka kopio järjestetään 
  * @return {Array} palauttaa järjestetyn _kopion_ sarjat-taulukosta
  */
function jarjestaSarjat(sarjat) {
//  console.log("jarjestaSarjat", sarjat);
  // Tämä palauttaa _taulukon_ kopion, mutta taulukon elementit ovat viitteitä, mikä ainakin tässä tehtävässä on tarpeeksi
  return sarjat.filter(e => e.kesto).toSorted((a, b) => a.kesto - b.kesto) ?? [];
}


/**
  * Taso 3
  * Lisää uuden sarjan ja palauttaa tiedon onnistuiko lisääminen vai ei
  * Sarja lisätään vain jos kaikki seuraavat ehdot täyttyvät:
  *  - Toista samannimistä sarjaa ei ole olemassa. Nimien vertailussa
  *    ei huomioida isoja ja pieniä kirjaimia tai nimen alussa ja lopussa välilyöntejä etc. (whitespace). Nimien vertailu on siis caseinsensitive.
  * "  Foo " on siis sama kuin "foo"
  *    sarjan nimi ei voi olla pelkkää whitespacea. 
  * - Sarjan keston täytyy olla kokonaisluku ja suurempi kuin 0
  * - Sarjan uniikki id on luotava seuraavalla tavalla: Käy läpi kaikki sarjat ja etsi suurin id, lisää tähän 1
  *  Uusi sarja lisätään Sarjat-taulukkoon viimeiseksi. Sarjan on oltava seuraavaa muotoa:
  *  {
  *     "id": {Number}, // Jokaisella sarjalle oleva uniikki kokonaislukutunniste, pakollinen tieto
  *     "nimi": {String}, // Sarjan uniikki nimi, pakollinen tieto
  *     "kesto": {Number}, // sarjan kesto tunteina, pakollinen tieto
  *     "alkuaika": {String}, // Sarjan alkuaika, oletuksena ""
  *     "loppuaika": {String}, // Sarjan loppuaika, oletuksena ""
  *  }
  * Tätä funktiota voi kokeilla, kun lisää sivulla olevalla lomakkeella uuden sarjan
  * @param {Array} sarjat - taulukko johon sarja lisätään 
  * @param {String} nimi - Lisättävän sarjan nimi
  * @param {String} kesto - Sarjan kesto merkkijonona
  * @param {String} alkuaika - Sarjan alkuaika, ei pakollinen
  * @param {String} loppuaika - Sarjan loppuaika, ei pakollinen
  * @return {Boolean} palauttaa true, jos sarja lisättiin tai false, jos lisäämistä ei tehty
  */
function lisaaSarja(sarjat, nimi, kesto, alkuaika, loppuaika) {
//  console.log("lisaaSarja", sarjat);
  const isUnique = !sarjat.find(e => !trimLocaleCompare(nimi, e.sarjanimi));
  kesto = Number(kesto);
  const isValidKesto = Number.isSafeInteger(kesto) && kesto > 0;
  if (nimi.trim() && isUnique && isValidKesto) {
    sarjat.push({
      id: getID(sarjat),
      sarjanimi: nimi,
      kesto,
      alkuaika: alkuaika ?? "",
      loppuaika: loppuaika ?? ""
    });
    return true;
  }
  return false;
}

/**
  * Taso 3
  * Poistaa joukkueen id:n perusteella data-rakenteesta ja palauttaa true tai false
  * @param {Array} joukkueet - taulukko josta joukkue poistetaan
  * @param {String} id - poistettavan joukkueen id
  * @return {Boolean} true, jos poisto onnistui tai false, jos poistettavaa joukkuetta ei löytynyt
  */
function poistaJoukkue(joukkueet, id) {
//  console.log("poistaJoukkue", joukkueet);
  id = Number(id);
  if (Number.isSafeInteger(id)) {
    const matchIndex = joukkueet.findIndex(e => e.id == id);
    if (matchIndex !== -1) {
      joukkueet.splice(matchIndex, 1);
      return true;
    }
  }
  return false;
}

/**
  * Taso 3
  * Järjestää rastit taulukkoon aakkosjärjestykseen rastikoodin perustella siten, että 
  * numeroilla alkavat rastit ovat kirjaimilla alkavien jälkeen. 
  * Esim. jos rastikoodit ovat 9B, 8A, 99, foobar, niin oikea järjestys olisi foobar, 8A, 99, 9B
  * isoilla ja pienillä kirjaimilla ei ole järjestämisessä merkitystä (case insensitive)
  * Jos saat konsoliin virheilmoituksen:
  *   Warning: Each child in a list should have a unique "key" prop.
  * et ole vielä asettanut rasteille oikeaa id:tä
  * Rastiobjektit on jäädytetty eli niitä ei voi muuttaa eikä
  * esim. lisätä niille ominaisuuksia vaan saa virheilmoituksen:
  * Object is not extensible
  * Joudut tekemään kustakin rastiobjektista kopion,
  * jotta kykenet palauttamaan haluttua muotoa olevan taulukon
  * @param {Object} rastit - Objekti, jonka sisältämistä rastiobjekteista muodostetaan järjestetty taulukko
  * @return {Array} palauttaa järjestetyn taulukon, joka sisältää kaikki rastiobjektit. Rastiobjektit ovat muotoa:
                                                     {
                                                        "id": rastit-objektissa käytetty kunkin rastiobjektin avain
                                                        "koodi": rastikoodi merkkijonona
                                                        "lat": latitude liukulukuna
                                                        "lon": longitude liukulukuna
                                                     }
  */
function jarjestaRastit(rastit) {
//  console.log("jarjestaRastit", rastit);
  const compare = (a, b) => {
    const koodiA = a.koodi;
    const koodiB = b.koodi;
    const numA = parseInt(koodiA);
    const numB = parseInt(koodiB);
    const isNumA = !isNaN(numA);
    const isNumB = !isNaN(numB);

    if (!isNumA && isNumB) {
      return -1;
    }
    if (isNumA && !isNumB) {
      return 1;
    }
    
    return trimLocaleCompare(koodiA, koodiB);
  };

  return Object.entries(rastit)
    .map(([k, v]) => ({ id: Number(k), ...v }))
    .toSorted(compare);
}


/**
  * Taso 3
  * Lisää joukkueen data-rakenteeseen ja palauttaa muuttuneen datan
  * Joukkue lisätään vain jos kaikki seuraavat ehdot täyttyvät:
  *  - Toista samannimistä joukkuetta ei ole olemassa. Nimien vertailussa
  *    ei huomioida isoja ja pieniä kirjaimia tai nimen alussa ja lopussa välilyöntejä etc. (whitespace). Nimien vertailu on siis caseinsensitive.
  *    "  Foo " on siis sama kuin "foo"
  *    Joukkueen nimi ei voi olla pelkkää whitespacea. 
  *  - Leimaustapoja on annettava vähintään yksi kappale. Leimaustapojen
  *     on löydyttävä data.leimaustavat-taulukosta
  *  - Jäseniä on annettava vähintään kaksi kappaletta. 
  *  - Saman joukkueen jäsenillä ei saa olla kahta samaa nimeä (caseinsensitive)
  *  - Sarjan id, jota vastaava sarja on löydyttävä data.sarjat-objektin sarjoista
  *
  *  Uusi joukkue tallennetaan data.joukkueet-taulukkoon. Joukkueen on oltava seuraavaa muotoa:
  *  {
  *     "id": {Number}, // jokaisella joukkueella oleva uniikki kokonaislukutunniste
  *     "jnimi": {String}, // Joukkueen uniikki nimi
  *     "jasenet": {Array}, // taulukko joukkueen jäsenien nimistä
  *     "leimaustapa": {Array}, // taulukko joukkueen leimaustapojen indekseistä (kts. data.leimaustavat)
  *     "rastileimaukset": {Array}, // taulukko joukkueen rastileimauksista. Oletuksena tyhjä eli []
  *     "sarja": {Object}, // viite joukkueen sarjaan, joka löytyy data.sarjat-taulukosta
  *     "pisteet": {Number}, // joukkueen pistemäärä, oletuksena 0
  *     "matka": {Number}, // joukkueen kulkema matka, oletuksena 0
  *     "aika": {String}, // joukkueen käyttämä aika "h:min:s", oletuksena "00:00:00"
  *  }
  * @param {Object} data - Objekti, jonka joukkueet-taulukkoon joukkue lisätään 
  * @param {String} nimi - Lisättävän joukkueen nimi
  * @param {Array} leimaustavat - Taulukko leimaustavoista
  * @param {String} sarja - Joukkueen sarjan id-tunniste
  * @param {Array} jasenet - joukkueen jäsenet
  * @return {Object} palauttaa muuttuneen datan
  */
function lisaaJoukkue(data, nimi, leimaustavat, sarja, jasenet) {
//  console.log("lisaaJoukkue", data);
  // Removes empty jasenet elements, even though function description doesn't specify that;
  //  otherwise new Joukkue would've empty members
  jasenet = jasenet.filter(e => e);
  const isUnique = !data.joukkueet?.find(e => !trimLocaleCompare(nimi, e.jnimi));  //väärin ilman optioita, Hässe == Hasse
  const leimaustavatIndices = leimaustavat.map(e => data.leimaustavat.findIndex(e2 => !trimLocaleCompare(e, e2)));
  const isValidLeimaustavat = leimaustavat.length >= 1 && leimaustavat.length == leimaustavatIndices.length;
  const isValidJasenet = jasenet.length >= 2;
  const isUniqueJasenet = jasenet.every((e, i) => {
    return !jasenet
      .filter((_, i2) => i !== i2)  // Jätetään oma indeksi pois tutkittavasta taulukosta
      .find(e2 => !trimLocaleCompare(e, e2));
  });
  const sarjaObj = data.sarjat.find(e => e.id == Number(sarja));
  if (nimi.trim() && isUnique && isValidLeimaustavat && isValidJasenet && isUniqueJasenet && sarjaObj) {
    data.joukkueet.push({
      id: getID(data.joukkueet),
      jnimi: nimi,
      jasenet,
      leimaustapa: leimaustavatIndices,
      rastilaimaukset: [],
      sarja: sarjaObj,
      pisteet: 0,
      matka: 0,
      aika: "00:00:00"
    });
  }
  return data;
}

/**
  * Taso 3
  * Laskee joukkueen käyttämän ajan. Tulos tallennetaan joukkue.aika-ominaisuuteen.
  * Käytä merkkijonoa, jossa aika on muodossa "hh:mm:ss". Esim. "07:30:35"
  * Jos aikaa ei kyetä laskemaan, ajaksi merkitään tyhjä merkkijono ""
  * Aika lasketaan viimeisestä (ajan mukaan) LAHTO-rastilla tehdystä leimauksesta alkaen aina
  * ensimmäiseen (ajan mukaan) MAALI-rastilla tehtyyn leimaukseen asti. Leimauksia jotka tehdään
  * ennen viimeistä lähtöleimausta tai ensimmäisen maalileimauksen jälkeen ei huomioida.
  * Mahdollisia MAALI-rastin leimauksia, jotka tehdään ennen viimeistä LAHTO-rastilla leimausta, ei huomioida
  * Ts. LAHTO-rastin leimaaminen nollaa aina kaikki leimaukset mukaanlukien mahdollisen MAALI-rastileimauksen
  * @param {Object} joukkue
  * @return {Object} joukkue
  */
function laskeAika(joukkue) {
  let {lahto, maali} = getLahtoMaali(joukkue.rastileimaukset);
  const lahtoDate = new Date(lahto?.aika);
  const maaliDate = new Date(maali?.aika);

  if (lahto && maali && lahtoDate < maaliDate) {
    joukkue.aika = ms2timeString(maaliDate - lahtoDate);
  } else {
    joukkue.aika = "";
  }

  return joukkue;
}

/**
  * Taso 3 ja Taso 5
  *  Järjestää joukkueet järjestykseen haluttujen tietojen perusteella
  *  järjestetään ensisijaisesti kasvavaan aakkosjärjestykseen 
  *  mainsort-parametrin mukaisen tiedon perusteella. mainsort voi olla joukkueen nimi, sarjan nimi, matka, aika tai pisteet
  *  Järjestäminen on tehtävä alkuperäisen taulukon kopiolle. Alkuperäistä ei saa muuttaa tai korvata.
  *  Joukkueen jäsenet järjestetään aina aakkosjärjestykseen. Alkuperäisen joukkueobjektin jäsenten järjestys ei saa muuttua.
  *  Joukkueen leimaustavat järjestetään myös aina aakkosjärjestykseen leimaustapojen nimien mukaan
  *  Isoilla ja pienillä kirjaimilla ei ole missään järjestämisissä merkitystä (case insensitive) eikä myöskään alussa tai lopussa olevalla whitespacella. Vertailu on siis caseinsensitive.
  *  sortorder-parametrin käsittely vain tasolla 5
  *  jos sortorder-parametrina on muuta kuin tyhjä taulukko, käytetään 
  *  sortorderin ilmoittamaa järjestystä eikä huomioida mainsort-parametria: 
  *  ensisijaisesti järjestetään taulukon ensimmäisen alkion tietojen perusteella, 
  *  toissijaisesti toisen jne.
  *  sortorder-taulukko sisältää objekteja, joissa kerrotaan järjestysehdon nimi (key),
  *  järjestyssuunta (1 = nouseva, -1 = laskeva) ja järjestetäänkö numeerisesti (true)
  *  vai aakkosjärjestykseen (false)
  *  Toteuta sortorder-taulukon käsittely siten, että taulukossa voi olla vaihteleva määrä rivejä
  *  Sarja täytyy huomioida erikoistapauksena
  *	 sortorder = [
  *	 {"key": "sarjanimi", "order": 1, "numeric": false},
  *	 {"key": "jnimi", "order": 1, "numeric": false},
  *	 {"key": "matka", "order": -1, "numeric": true},
  *	 {"key": "aika", "order": 1, "numeric": false},
  *	 {"key": "pisteet", "order": -1, "numeric": true}
  *	]
  * @param {Object} data - tietorakenne, jonka data.joukkueet-taulukko järjestetään 
  * @param {String} mainsort - ensimmäinen (ainoa) järjestysehto, joka voi olla nimi, sarja, matka, aika tai pisteet  TASO 3
  * @param {Array} sortorder - mahdollinen useampi järjestysehto TASO 5
  * @return {Array} palauttaa järjestetyn ja täydennetyn _kopion_ data.joukkueet-taulukosta
  */
function jarjestaJoukkueet(data, mainsort="nimi", sortorder=[] ) {
  // Gets the property of the `obj` based on `mainsort` key and converts it's value to string
  mainsort = mainsort == "nimi" ? "jnimi" : mainsort;
  const getVal = (obj, key) => (key == "sarjanimi" ? obj.sarja.sarjanimi : obj[key]).toString();
  const sortArray = sortorder.length ? sortorder : [{key: mainsort, order: 1, numeric: false}];
  const joukkueet = data.joukkueet
    .map(e => ({ ...e }))
    .toSorted((a, b) => {
      let cval = 0;
      for (const sort of sortArray) {
        const valA = getVal(a, sort.key);
        const valB = getVal(b, sort.key);
        const options = {numeric: sort.numeric};
        const compare = trimLocaleCompare(valA, valB, options);
        if (compare) {
          cval = compare * sort.order;
          break;
        }
      }
      return cval;
    });
  joukkueet.forEach(e => {
    e.jasenet = e.jasenet.filter(e => e).toSorted(trimLocaleCompare);
    e.leimaustapa = e.leimaustapa.toSorted((a, b) => trimLocaleCompare(data.leimaustavat[a], data.leimaustavat[b]));
  });
  return joukkueet;
}

/**
  * Taso 5
  * Laskee joukkueen kulkeman matkan. Matka tallennetaan joukkue.matka-ominaisuuteen kokonaisluvuksi pyöristettynä
  * Laske kuinka pitkän matkan kukin joukkue on kulkenut eli laske kunkin rastivälin
  * pituus ja laske yhteen kunkin joukkueen kulkemat rastivälit. Jos rastille ei löydy
  * sijaintitietoa (lat ja lon), niin kyseistä rastia ei lasketa matkaan mukaan. Matka
  * lasketaan viimeisestä LAHTO-rastilla tehdystä leimauksesta alkaen aina
  * ensimmäiseen MAALI-rastilla tehtyyn leimaukseen asti. Leimauksia jotka tehdään
  * ennen lähtöleimausta tai maalileimauksen jälkeen ei huomioida.
  * Käytä annettua apufunktiota getDistanceFromLatLonInKm
  * @param {Object} joukkue
  * @return {Object} joukkue
  */
function laskeMatka(joukkue) {
  const {rastileimaukset, lahtoIndex, maaliIndex} = getLahtoMaali(joukkue.rastileimaukset);

  joukkue.matka = Math.round(rastileimaukset.slice(lahtoIndex, maaliIndex + 1).reduce((a, b) => {
    const latB = parseFloat(b.rasti.lat);
    const lonB = parseFloat(b.rasti.lon);

    // Does not calculate distance at first element
    if (a.lat !== -1) {
      a.matka += getDistanceFromLatLonInKm(a.lat, a.lon, latB, lonB);
    }

    a.lat = latB;
    a.lon = lonB;
    return a;
  }, {matka: 0, lat: -1, lon: -1}).matka);

  return joukkue;
}

/**
  * Taso 5
  * Laskee joukkueen saamat pisteet. Pistemäärä tallennetaan joukkue.pisteet-ominaisuuteen
  * Joukkue saa kustakin rastista pisteitä rastin koodin ensimmäisen merkin
  * verran. Jos rastin koodi on 9A, niin joukkue saa yhdeksän (9) pistettä. Jos rastin
  * koodin ensimmäinen merkki ei ole kokonaisluku, niin kyseisestä rastista saa nolla
  * (0) pistettä. Esim. rasteista LÄHTÖ ja F saa 0 pistettä.
  * Samasta rastista voi sama joukkue saada pisteitä vain yhden kerran. Jos
  * joukkue on leimannut saman rastin useampaan kertaan lasketaan kyseinen rasti
  * mukaan pisteisiin vain yhden kerran.
  * Rastileimauksia, jotka tehdään ennen lähtöleimausta tai maalileimauksen jälkeen, ei
  * huomioida.
  * Maalileimausta ei huomioida kuin vasta lähtöleimauksen jälkeen.
  * Jos joukkueella on useampi lähtöleimaus, niin pisteet lasketaan vasta
  * viimeisen lähtöleimauksen jälkeisistä rastileimauksista.
  * Joukkue, jolla ei ole ollenkaan rastileimauksia, saa 0 pistettä
  * @param {Object} joukkue
  * @return {Object} joukkue
  */
function laskePisteet(joukkue) {
  const {rastileimaukset, lahtoIndex, maaliIndex} = getLahtoMaali(joukkue.rastileimaukset);

  joukkue.pisteet = rastileimaukset.slice(lahtoIndex, maaliIndex + 1).reduce((a, b) => {
    if (!a.usedKoodi.includes(b.rasti.koodi)) {
      a.pisteet += parseInt(b.rasti.koodi[0]) || 0;
      a.usedKoodi.push(b.rasti.koodi);
    }
    return a;
  }, {pisteet: 0, usedKoodi: []}).pisteet;

  return joukkue;
}



// apufunktioita tasolle 5
/**
  * Laskee kahden pisteen välisen etäisyyden
  */
function getDistanceFromLatLonInKm(lat1,lon1,lat2,lon2) {
  let R = 6371; // Radius of the earth in km
  let dLat = deg2rad(lat2-lat1);  // deg2rad below
  let dLon = deg2rad(lon2-lon1);
  let a =
    Math.sin(dLat/2) * Math.sin(dLat/2) +
    Math.cos(deg2rad(lat1)) * Math.cos(deg2rad(lat2)) *
    Math.sin(dLon/2) * Math.sin(dLon/2)
    ;
  let c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1-a));
  let d = R * c; // Distance in km
  return d;
}
/**
   Muuntaa asteet radiaaneiksi
  */
function deg2rad(deg) {
  return deg * (Math.PI/180);
}

